# Vibe Coding 常见问题和解决


你好，我是程序员鱼皮，前腾讯全栈开发，全网 200 万粉的 [AI 编程博主](https://space.bilibili.com/12890453)，也是 [AI 导航](https://ai.codefather.cn) 和 [编程导航](https://www.codefather.cn) 等 10+ 自研产品的创造者。

之前我系统讲解了 Vibe Coding 的各种技巧和方法，这篇文章我来汇总一下大家在 Vibe Coding 实践中最常遇到的问题和解决方案。

你可以把它当作速查手册。遇到问题时，先来这里找找，说不定就能找到答案。如果这里没有，也可以去我的 [编程导航](https://www.codefather.cn/) 提问，或者在 [鱼皮 AI 导航](https://ai.codefather.cn/) 中跟其他 AI 爱好者交流并寻找答案。




## Vibe Coding 概念理解


### Vibe Coding 和传统编程有什么区别？

回答：传统编程是你自己写代码，Vibe Coding 是你用自然语言描述需求，让 AI 帮你写代码。传统编程需要你掌握编程语言的语法和细节，Vibe Coding 更注重需求的表达和 AI 的引导。但本质上，它们都是在解决问题，只是方式不同。你可以把传统编程理解成自己做饭，Vibe Coding 理解成点外卖 —— 最终都能吃上饭，但过程完全不一样。



### Vibe Coding 适合所有人吗？

回答：Vibe Coding 降低了编程的门槛，让更多人能参与开发。但它不是万能的，对于非常复杂的系统、对性能要求极高的项目、需要深度优化的场景，传统编程可能更合适。Vibe Coding 最适合快速原型开发、个人项目、中小型应用、工具类软件等场景。如果你是零基础想学编程，或者想快速把想法变成产品，Vibe Coding 就很适合你。




### 学了 Vibe Coding 还需要学传统编程吗？

回答：需要，但不用急。Vibe Coding 能帮你快速实现功能，但要真正理解代码、调试复杂问题、优化性能，还是需要编程基础。建议边用 Vibe Coding 做项目，边学习编程知识。这样学习效率更高，也更有动力。你可以先用 AI 做出几个项目，有了成就感后再系统学习编程，会比一开始就啃书本有意思得多。




### AI 生成的代码靠谱吗？

回答：AI 生成的代码能用，但不一定完美。它可能有 bug、性能问题、安全隐患。所以你需要测试功能、审查代码、持续优化。不要盲目相信 AI，要保持批判性思维。就像你点外卖也要检查一下菜品是否新鲜一样，AI 生成的代码也需要你把关。不过随着 AI 模型的进步，代码质量已经越来越高了。




### Vibe Coding 会取代程序员吗？

回答：不会完全取代，但会改变程序员的工作方式。就像计算器没有取代数学家，搜索引擎没有取代图书馆员一样，AI 编程工具会成为程序员的助手，而不是替代品。未来的程序员需要更强的产品思维、架构能力和问题解决能力，而不只是写代码的能力。会用 AI 的程序员会比不会用的更有竞争力。




### 什么是 AI 幻觉？

回答：AI 幻觉是指 AI 编造了不存在的内容，比如虚构了一个不存在的 API、错误的函数用法、或者根本不存在的库。这是 AI 模型的固有问题，因为它是基于概率生成内容的。遇到幻觉时，不要慌，要求 AI 提供文档链接验证，或者自己查官方文档确认。如果 AI 坚持错误，可以换个模型试试，或者开新对话重新描述问题。




### MVP 是什么意思？

回答：MVP 是 Minimum Viable Product 的缩写，意思是最小可行产品。简单来说就是先做一个最简单但能用的版本，然后再慢慢完善。比如做记账应用，MVP 版本可能只有记录支出、查看列表、计算总额这三个功能，其他的分类、图表、导出等功能以后再加。这样做的好处是能快速验证想法，避免一开始就陷入细节，保持开发动力。




### 什么是上下文窗口？

回答：上下文窗口是指 AI 模型一次能 “记住” 的内容量，通常用 Token 来衡量。比如 Claude Sonnet 4.5 的上下文窗口是 200K Token，大约相当于 15 万个中文字。上下文窗口越大，AI 能处理的代码量就越多，能记住的对话历史就越长。如果你的项目代码很多，选择上下文窗口大的模型会更合适，比如 Gemini 3 Pro 支持 1M Token。




## Vibe Coding 工具选择


### Cursor 和 Windsurf 哪个更好？

回答：两个都很好，各有特点。Cursor 生态更成熟，社区更大，插件更多，文档更完善。Windsurf 有一些创新功能比如 Cascade 模式，界面也更现代。

如果你是新手，建议从 Cursor 开始，因为遇到问题更容易找到解决方案。如果你喜欢尝鲜，可以试试 Windsurf。当然最好的办法是 “我全都要”，两个都试试，看哪个更适合你的工作方式。




### 免费版够用吗？

回答：对于学习和小项目，免费版够用。Cursor 免费版每月有一些特定模型的额度。但如果是日常工作或大项目，建议用付费版。付费版的额度更多，模型更强，体验更好，本质是拿金钱换时间。

可以先用免费版试试，觉得好用再升级。学生党可以充分利用各种免费资源，完全够学习使用了。




### 如何选择 AI 模型？

回答：根据任务复杂度和预算选择。简单任务用便宜的模型（Gemini Flash、DeepSeek），复杂任务用强大的模型（Claude Opus、GPT-5）。如果做前端 UI，Gemini 3 Pro 表现很好。如果做全栈项目，Claude Sonnet 比较全面。如果预算有限，国产模型（DeepSeek、通义千问、智谱 GLM）性价比很高。

如果不确定，可以用 Auto 模式让工具自动选择，或者先用便宜的模型试试，不行再换强模型。




### Bolt.new 和 v0.dev 有什么区别？

回答：Bolt.new 更适合做全栈应用，能生成完整的前后端代码，还能直接在浏览器里运行和调试。v0.dev 更专注于前端 UI 组件，特别擅长生成漂亮的界面。如果你想快速做一个完整的应用，用 Bolt.new。如果你只是想生成一些 UI 组件，用 v0.dev。两个都是零代码平台，不需要安装软件，打开浏览器就能用，特别适合新手。




### API Key 在哪里获取？

回答：去对应服务的官网注册账号，然后在设置或 API 页面生成 Key。比如 OpenAI 的 Key 在 platform.openai.com 获取，Anthropic 的 Claude Key 在 console.anthropic.com 获取，Supabase 的 Key 在项目设置里。

生成 API Key 后记得妥善保管，不要泄露，也不要提交到 GitHub 等公开仓库。建议用环境变量或配置文件来管理 API Key，避免硬编码在代码里。




### 如何在国内访问 Cursor 和 Claude？

回答：Cursor 可以直接访问，但 Claude 官网在国内访问可能有困难。可以使用国产模型替代，比如 DeepSeek、通义千问、智谱 GLM 在编程能力上已经很接近国际模型了，而且访问速度更快，价格更便宜。如果一定要用 Claude，可以考虑使用 API 方式，或者通过 OpenRouter 等中转服务。




### Cursor 有哪些 AI 模式？

回答：Cursor 2.0 主要提供了 2 大 AI 交互模式

1. Chat 模式：对话模式，适合问问题、解释代码、小范围修改。
2. Agent 模式：最强大的模式，可以自主规划和执行复杂任务，能同时修改多个文件，支持并行运行多个代理。

如果你只是想问问题或改一个函数，用 Chat 就够了。如果要添加新功能、涉及多个文件的修改，用 Agent 更合适。Agent 模式还支持 Plan Mode，会先生成计划让你确认，再执行修改。




### 选择零代码平台还是代码编辑器？

回答：如果你是完全零基础，或者只是想快速做个原型，用零代码平台（Bolt.new、v0.dev）。如果你想做复杂项目，需要更多控制权，或者想学习编程，用代码编辑器（Cursor、Claude Code 等）。

零代码平台简单快速，但灵活性有限。代码编辑器功能强大，但学习难度更大。建议先用零代码平台体验一下，有了感觉再学代码编辑器。




## Vibe Coding 使用技巧


### AI 生成的代码报错怎么办？

回答：把完整的错误信息和相关代码复制给 AI，让它分析和修复。注意要包含完整的错误堆栈，不要只复制一句话。如果 AI 修复不了，可以切换到更强的模型试试，或者开新对话重新描述问题。也可以自己查文档或搜索解决方案，在社区或论坛求助。很多时候错误信息本身就包含了解决线索，学会看错误信息很重要。




### AI 总是用错误的技术栈怎么办？

回答：在每次对话开始时，明确说明你的技术栈。比如 “我用的是 React + TypeScript + Tailwind CSS，请用这些技术实现”。

或者在项目中配置 `.cursorrules` 规则文件，让 AI 自动知道你的技术栈。

如果 AI 还是用错，及时中断并纠正：“我用的是 React，不是 Vue，请用 React 重写！”

多次强调后 AI 就会记住了。




### 如何让 AI 生成的代码更符合项目风格？

回答：提供参考代码，让 AI 模仿。比如：“请参考这个组件的风格来写新组件”，然后贴上参考代码。

或者在上下文文件中详细说明代码风格，包括命名规则、组件结构、注释格式等。

还可以提供一个代码规范文档，让 AI 按照规范来写。

最重要的是，提示词越具体越好，不要只说 “写得好看一点”，要说清楚什么是好看。




### AI 生成的代码性能不好怎么办？

回答：先用 Chrome DevTools、Lighthouse 等工具找到性能瓶颈，然后让 AI 针对性地优化。比如 “这个列表渲染很慢，请用虚拟滚动优化”，或者 “这个函数在大数据量时很慢，请优化算法”。

不要一开始就追求完美性能，先让功能跑起来，发现瓶颈再优化，大部分情况下 AI 生成的代码性能已经够用了。




### 如何处理 AI 的幻觉？

回答：如果 AI 编造了不存在的 API，要求它提供文档链接。如果提供不了，说明是幻觉，让它用正确的 API。

如果 AI 陷入死循环，切断上下文，开新对话。

如果 AI 坚持错误方案，换个模型试试，或者自己查文档确认。

遇到不确定的内容，一定要验证，不要盲目相信。建议养成查文档的习惯，这是程序员的基本功。




### 如何调试 AI 生成的代码？

回答：使用断点调试，而不是只用 console.log。

可以在浏览器或编辑器中设置断点，单步执行代码，查看变量值。这样能更清楚地看到代码的执行过程。如果还是找不到问题，把错误信息和代码给 AI，让它帮你分析。也可以让 AI 添加详细的日志，帮助你理解代码的执行流程。

调试是程序员的必备技能，值得多花时间学习。




### 如何提高提示词的质量？

回答：提示词要具体、清晰、有结构。不要说 “做一个网站”，要说 “做一个记账网站，包含添加支出、查看列表、统计总额三个功能，界面用蓝色调，简洁现代风格”。

可以把提示词分成几个部分：功能需求、界面要求、技术要求。还可以提供参考案例，比如 “界面风格参考 Notion”。

记住，提示词写得越详细，AI 生成的结果越符合预期。




### AI 生成的代码太冗长怎么办？

回答：让 AI 重构代码，提取重复部分，简化逻辑。比如 “这段代码太长了，请重构一下，提取公共函数，减少重复”。或者 “请用更简洁的方式实现这个功能”。

AI 一般会优先让代码能跑起来，而不是追求简洁，所以需要你主动要求优化。不过也不要过度追求简洁，可读性更重要。




### 如何让 AI 解释代码？

回答：通过让 AI 解释代码，你能更快地理解和学习。可以直接问 AI “这段代码是做什么的？请详细解释”，或者 “这个函数的逻辑是什么？为什么要这样写？”。AI 会用通俗易懂的语言给你解释。

如果解释太简单，可以说 “请更详细地解释，包括每一步的作用”。如果解释太复杂，可以说 “请用更简单的语言解释，我是新手”，甚至可以说 “我是傻子”，效果可能会出其不意~




### 如何处理 AI 生成的过时代码？

回答：AI 的训练数据可能有滞后，所以有时会生成旧版本的代码。你需要明确告诉 AI 使用最新版本，比如 “请用 React 19 的最新写法” 或者 “请用 Next.js 15 的 App Router”。并且一定要提供给 AI 最新的官方文档。




### 如何在提示词中加入代码示例？

回答：直接把代码用三个反引号包裹起来，然后贴到提示词里。比如：

````markdown
请参考这段代码的风格：

```jsx
代码内容
```
````

如果代码比较长，可以只贴关键部分。也可以利用 AI 代码编辑器的 `@` 能力，让 AI 读取项目中的文件，比如 “请参考 @src/components/Button.tsx 的风格”。提供代码示例能让 AI 更准确地理解你的需求。




### AI 总是生成重复的代码怎么办？

回答：提醒 AI 提取公共函数或组件。比如 “这些代码有很多重复，请提取成公共函数” 或者 “请创建一个可复用的组件”。也可以在提示词里明确说 “避免重复代码，使用 DRY 原则”。如果 AI 还是生成重复代码，可以自己手动重构，或者换个模型试试。




### 如何处理 AI 生成的不安全代码？

回答：让 AI 审查代码的安全性。比如 “请检查这段代码是否有安全问题” 或者 “请添加输入验证，防止 XSS 攻击”。也可以使用安全扫描工具，比如前端代码可以用 ESLint 的安全插件。对于敏感操作（比如用户认证、支付），一定要格外小心，最好请有经验的开发者、或者多用几个不同的高级 AI 模型来交叉验证。




## Vibe Coding 项目开发


### 项目做到一半代码变得很乱怎么办？

回答：及时重构，不要等到完全乱套了再处理。每完成一个功能，花 10 ~ 15 分钟整理一下代码。提取重复代码，拆分大函数，改进命名，添加注释。

如果已经很乱了，可以让 AI 帮你重构，但要小步进行，每一步都要测试。比如 “请帮我重构这个文件，提取公共函数”，而不是 “重构整个项目”。小步快跑，逐步改进。

注意，重构前一定要先用 Git 提交当前代码！这样即使重构出问题，也能随时回退到之前的版本。养成频繁提交的习惯，是保护代码的最好方式。




### 如何部署 AI 生成的项目？

回答：很多零代码平台（比如 Bolt.new）支持一键部署，点个按钮就能上线。

如果要手动部署，可以用 Vercel、Netlify 等平台。把代码推送到 GitHub，然后在平台上连接仓库，它会自动构建和部署。

如果需要后端，可以用 Supabase 等 BaaS 服务。如果需要用自己的服务器，可以利用 Docker 容器化部署。

总之，部署其实没那么难，跟着鱼皮的部署教程一步步来就行。




### 项目上线后出了 bug 怎么办？

回答：首先，用监控工具（Sentry、LogRocket）收集错误信息。然后，在本地复现问题，找到原因。

修复后，让 AI 多写测试，确保问题不再出现。最后尽快部署修复版本。

为了避免这种情况，上线前要充分测试，包括功能测试、边界情况测试、不同设备测试。可以让朋友帮忙测试，往往能发现你一个人没注意到的问题。




### 如何从玩具项目变成真正的产品？

回答：需要考虑到很多方面，比如

1. 完善错误处理，考虑各种异常情况
2. 添加测试，确保功能稳定
3. 优化性能，让应用跑得更快
4. 加强安全，保护用户数据
5. 改进 UI，让应用更好用
6. 写好文档，方便维护和扩展
7. 还要考虑 SEO、监控、日志等

这是一个持续改进的过程，不要想着一步到位。每次改进一点，慢慢就能变成真正的产品。




### 如何评估项目的质量？

回答：不要只关注功能，质量同样重要。一个功能完整但 bug 一堆的项目，不如一个功能简单但稳定可靠的项目。

可以从这几个方面评估：

- 功能完整性（是否实现了所有需求）
- 代码质量（是否清晰、可维护）
- 性能表现（加载速度、响应速度）
- 安全性（有没有漏洞）
- 用户体验（是否好用）
- 测试覆盖率（是否有足够的测试）




### 遇到 AI 解决不了的问题怎么办？

回答：首先，一定不要对着一个 AI 死磕，可以换个 AI 模型试试，不同模型擅长的领域不一样。

如果你有编程基础，最好看看官方文档，文档是最权威的资料。

或者搜索类似问题的解决方案，比如 GitHub Issues 区，因为很多问题别人已经遇到过了，照搬解决方案就好。

还可以在社区或论坛求助，比如在  [编程导航](https://codefather.cn/) 提问；或者请教有经验的开发者，有时候一句话就能点醒你。

记住，AI 是工具，不是万能的，人的智慧同样重要。




### 如何管理项目的版本和代码？

回答：用 Git 做版本控制，把代码托管到 GitHub。

- 每完成一个功能就提交一次，写清楚提交信息
- 如果要尝试新功能，创建新分支，测试没问题再合并
- 定期备份代码，避免数据丢失
- 如果是团队协作，制定好分支策略和代码规范

Git 是程序员的必备技能，绝对值得花时间学习。但是不用死记硬背 Git 的命令，因为 AI 就可以帮你搞定。




### 如何处理项目依赖和包管理？

回答：用 npm 或 pnpm 管理依赖，定期更新包版本。

还要注意下面几点：

1. 注意检查包的安全性，避免使用有漏洞的包。
2. 如果遇到依赖冲突，可以让 AI 帮你解决
3. 不要安装太多不必要的包，每个包都会增加项目体积和复杂度
4. 定期清理不用的依赖，保持项目整洁

如果不确定要用哪个包，可以让 AI 推荐，它会给你几个选择和对比。




### 如何测试 AI 生成的代码？

回答：如果是重要项目，可以让 AI 帮你写自动化测试，比如单元测试、集成测试。

但是不要完全相信 AI，必须手动测试！把每个功能都点一遍，试试各种边界情况。

测试不仅能发现 bug，还能让你更了解代码的行为。不要觉得测试浪费时间，它能帮你省下更多调试的时间。还可以让朋友或邀请用户帮忙测试，他们往往能发现你没想到的问题。




### 如何优化 AI 生成的 UI 界面？

回答：可以让 AI 参考优秀的设计，比如通过文字描述 “界面风格参考 Notion，简洁现代”，或者找一些优秀网站的截图贴给 AI 理解并参考。

如果你有一定的编程基础，或者有自己喜欢的 UI 组件库，可以直接推荐给 AI。比如 Ant Design、Material-UI、shadcn/ui，它们提供了现成的漂亮组件。

记住，好的 UI 不是花哨，而是清晰、一致、好用。




### 如何处理多人协作开发？

回答：使用 Git 分支管理，每个人在自己的分支上开发，完成后合并到主分支。

此外，还有几个重要事项：

1. 制定代码规范，保持代码风格一致。可以让 AI 帮你生成团队协作文档，包括开发规范、Git 工作流等。
2. 使用 Pull Request 进行代码审查，互相学习
3. 定期同步代码，避免冲突
4. 使用项目管理工具（比如 Notion）分配任务
5. 保持沟通，遇到问题及时讨论




### 如何给项目添加数据库？

回答：最简单的方法是用 BaaS 服务，比如 Supabase、Firebase。它们提供了数据库、认证、存储等功能，不需要自己搭建服务器。

直接告诉 AI “请集成 Supabase 数据库”，它会帮你生成代码。

对于小项目，BaaS 服务完全够用，而且省心。

如果需要更多控制权，可以用 PostgreSQL、MongoDB 等数据库，但需要自己部署和管理。




### 如何处理用户认证和授权？

回答：不要自己从零实现认证系统，太容易出安全问题。建议使用现成的方案，比如 Supabase Auth、Firebase Auth、Auth0、NextAuth.js。这些方案提供了完整的认证流程，包括邮箱验证、密码重置、第三方登录等。

直接告诉 AI “请用 NextAuth.js 实现用户登录注册”，它会帮你集成。

如果是学习项目，可以简单实现，但商业项目一定要用成熟方案。




## Vibe Coding 学习成长


### 零基础能学 Vibe Coding 吗？

回答：完全可以。Vibe Coding 降低了编程门槛，零基础也能上手。建议从零代码平台（Bolt.new）开始，先做出几个小项目，建立信心。然后边做边学，了解一些基本的编程概念，比如变量、函数、条件判断、循环等。不用一开始就学很深，能看懂 AI 生成的代码就行。慢慢地，你会发现自己能理解越来越多，甚至能自己修改代码了。




### 学习 Vibe Coding 需要多长时间？

回答：入门很快，不到 10 分钟就能做出第一个项目。但要熟练掌握，需要日复一日的实践。建议每天花 1 ~ 2 小时练习，先做一些小项目积累经验、然后尝试做商业级产品。

记住，学习是持续的过程，不要急于求成。重要的不是学多快，而是能不能坚持。每天进步一点点，几个月后回头看，你会惊讶于自己的成长。




### 有哪些学习资源推荐？

回答：

1. 官方文档是最好的资源，比如 Cursor 的文档、Claude 的文档。
2. [鱼皮的AI 导航](https://ai.codefather.cn/) 收录了大量 AI 工具和学习资源。
3. B 站、YouTube 上有很多 Vibe Coding 的视频教程，我在 “程序员鱼皮” 这个账号也经常做这方面的分享。
4. GitHub 上有 awesome-vibe-coding 这样的资源合集
5. 还可以加入 [编程导航](https://www.codefather.cn/) 等开发者社区，和其他人交流学习。




### 如何提高 Vibe Coding 水平？

回答：多实践是最重要的。

- 做各种类型的项目，从简单到复杂
- 学习优秀的提示词和对话技巧，看别人是怎么用 AI 的。
- 理解 AI 生成的代码，不要只是复制粘贴。
- 总结经验教训，记录遇到的问题和解决方法。
- 保持学习，关注新工具和新技术。
- 可以尝试重构之前的项目，用新学的技巧改进它
- 教别人也是很好的学习方式，能加深你的理解，输出促进输入




### 如何平衡 AI 辅助和自主学习？

回答：不要完全依赖 AI，也不要完全排斥 AI。可以先让 AI 生成代码，然后自己理解和修改。遇到不懂的地方，先自己思考，再问 AI。

如果你还处于入门阶段，可以定期做一些不用 AI 的练习，巩固基础。

**记住，AI 是工具、是加速器，但不能代替你的思考。**

就像计算器不能代替数学思维一样，AI 不能代替编程思维。用 AI 提高效率，用思考提升能力。




### 如何保持学习动力？

回答：做自己感兴趣的项目，而不是为了学习而学习。

你可以：

- 设定小目标，每完成一个就奖励自己
- 和朋友一起学习，互相鼓励
- 分享你的作品，获得反馈和认可
- 记录学习过程，看到自己的进步

学习是马拉松，不是短跑，慢慢来，享受过程。最重要的是，记住你为什么开始学习，想做什么，想成为什么样的人。不要和别人比，而是和过去的自己比。




## Vibe Coding 成本和效率


### 如何控制 AI 使用成本？

回答：有非常多节省真金白银的技巧

- 简单任务用便宜的模型，复杂任务才用贵的模型
- 充分利用免费资源，比如 DeepSeek、通义千问的免费额度
- 优化提示词，一次说清楚，减少反复对话
- 避免让 AI 生成大量不必要的代码
- 使用缓存功能，减少重复计算

如果是学习阶段，免费资源完全够用。如果是商业项目，成本是值得的，因为 AI 能大大提高效率，节省的人力成本远超 AI 成本。



### 如何提高开发效率？

回答：有很多提高效率的技巧：

- 使用快捷键，减少鼠标操作
- 利用 Agent 模式，让 AI 自动化工作，减少人工投入的时间
- 准备好提示词模板，常用的需求直接套用
- 使用代码片段，快速插入常用代码
- 配置好开发环境，减少重复工作
- 学习一些基础知识，能更快理解和修改 AI 生成的代码

最重要的是，做好规划，想清楚再动手，避免返工。Vibe Coding 完整项目时，真正的效率不是快，而是少走弯路。



### 如何避免重复劳动？

回答：程序员的优点就是 “懒”，避免重复劳动的关键就是 **沉淀和复用**。

具体的几种做法：

- 把常用的提示词、配置、代码片段保存起来，需要时直接复制，或者让 AI 复用。
- 使用模板项目，新项目基于模板创建，而不是从 0 开始生成
- 把解决过的问题记录下来，下次遇到直接查阅
- 建立自己的知识库，积累经验



### 如何选择合适的订阅计划？

回答：如果是学习阶段，先用免费版，不够用再升级。如果是日常工作或者要做个商业项目，订阅 Cursor Pro 的性价比最高。如果需要大量使用，可以考虑 API 按量付费。如果预算有限，国产模型的订阅更便宜。

总之，不要一开始就订阅最贵的，先试用，找到最适合自己的。也不要排斥付费，毕竟工具是为了提高效率，如果能帮你节省时间，成本就是值得的。



## 写在最后

这篇文章汇总了几十个常见问题，涵盖了概念理解、工具选择、使用技巧、项目开发、学习成长、成本效率等各个方面。这些问题都是我本人在实践中遇到的、或者在 [AI 编程社区](https://ai.codefather.cn/) 里经常被学员们问到的。

当然，Vibe Coding 还在快速发展，新的问题会不断出现，新的解决方案也会不断涌现。建议你保持学习、多关注社区动态、多和其他开发者交流，无限进步！






## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
